<?php
/* @var $this UserController */
/* @var $model User */
/* @var $form CActiveForm */
?>

<div class="form">

    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'user-form',
        // Please note: When you enable ajax validation, make sure the corresponding
        // controller action is handling ajax validation correctly.
        // There is a call to performAjaxValidation() commented in generated controller code.
        // See class documentation of CActiveForm for details on this.
        'enableAjaxValidation' => false,
    ));
    ?>

    <p class="note">Fields with <span class="required">*</span> are required.</p>

    <?php echo $form->errorSummary($model); ?>

    <div class="row">
        <?php echo $form->labelEx($model, 'username'); ?>
        <?php echo $form->textField($model, 'username', array('size' => 20, 'maxlength' => 20)); ?>
        <?php echo $form->error($model, 'username'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'password'); ?>
        <?php echo $form->passwordField($model, 'password', array('size' => 60, 'maxlength' => 128)); ?>
        <?php echo $form->error($model, 'password'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'email'); ?>
        <?php echo $form->textField($model, 'email', array('size' => 60, 'maxlength' => 128)); ?>
        <?php echo $form->error($model, 'email'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'phone'); ?>
        <?php echo $form->textField($model, 'phone'); ?>
        <?php echo $form->error($model, 'phone'); ?>
    </div>

    <!--    <div class="row">
    <?php //echo $form->labelEx($model, 'created_at'); ?>
    <?php
//        $this->widget('zii.widgets.jui.CJuiDatePicker', array(
//            'name' => 'created_at',
//            'value' => $model->created_at,
//            'options' => array(
//                'showAnim' => 'slideDown', //'slide','fold','slideDown','fadeIn','blind','bounce','clip','drop'
//                'showButtonPanel' => true,
//            ),
//            'htmlOptions' => array(
//                'style' => ''
//            ),
//        ));
    ?>
    <?php //echo $form->error($model, 'created_at'); ?>
        </div>-->

    <div class="row buttons">
        <?php echo CHtml::submitButton($model->isNewRecord ? 'Create' : 'Save', array('class' => 'btn btn-secondary')); ?>
        <?php
        $userStatus = Yii::app()->user->getState('__statusAdmin');
        if ($userStatus == 'Admin') {
            echo CHtml::submitButton('Cancel', array('submit' => array('/user/admin/'), 'class' => 'btn btn-secondary'));
        } else {
            echo CHtml::submitButton('Cancel', array('submit' => array('/user/view/' . Yii::app()->user->getState('__userid')), 'class' => 'btn btn-secondary'));
        }
        ?>

        <?php ?>
    </div>

    <?php $this->endWidget(); ?>

</div><!-- form -->
<style>
    textArea {
        width: 360px;
    }
</style>