<?php
/* @var $this CompanyController */
/* @var $model Company */

//$this->breadcrumbs = array(
//    'Companies' => array('index'),
//    'Manage',
//);

$this->menu = array(
//    array('label' => 'List Users', 'url' => array('/user/admin/')),
    array('label' => 'List Company', 'url' => array('index')),
    array('label' => 'Create Company', 'url' => array('create')),
    array('label' => 'Upload Companies', 'url' => array('/user/uploadcompany/')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$('#company-grid').yiiGridView('update', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h4>Manage Companies</h4>

<?php if(Yii::app()->user->hasFlash('error')):?>
    <div class="info">
        <h5 style="color: red;"><?php echo Yii::app()->user->getFlash('error'); ?></h5>
    </div>
<?php endif; ?>
<?php
$Criteria = new CDbCriteria();
$mymodel = Company::model()->findAll($Criteria);
if ($mymodel == NULL) {
    echo'No records found';
} else {
    ?>
    <div class="span2 right">
        <?php
        echo CHtml::submitButton('Export Report', array('submit' => array('/user/exportexceladmin/'), 'class' => 'btn btn-secondary'));
        ?>
    </div>
    <div class="span1 right">
        <?php
        echo CHtml::submitButton('Delete All', array('submit' => array('/company/deletealladmin/'), 'class' => 'btn btn-secondary'));
        ?>
    </div>
    <div style="height:20px;"></div>
    <?php
}
?>





<!--<p>
You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>-->

<?php // echo CHtml::link('Advanced Search','#',array('class'=>'search-button'));     ?>
<div class="search-form" style="display:none">
    <?php
    $this->renderPartial('_search', array(
        'model' => $model,
    ));
    ?>
</div><!-- search-form -->

<?php
$userStatus = Yii::app()->user->getState('__statusAdmin');
if ($userStatus == 'Admin') {
    $this->widget('zii.widgets.grid.CGridView', array(
        'id' => 'company-grid',
        'dataProvider' => $model->search(),
        'filter' => $model,
        'columns' => array(
            'id',
            'user_id',
            'name',
            'adress',
            'phone',
            'city',
            /*
              'state',
              'zip',
              'contacts',
             */
            array(
                'class' => 'CButtonColumn',
            ),
        ),
    ));
} else {
    $this->widget('zii.widgets.grid.CGridView', array(
        'id' => 'company-grid',
        'dataProvider' => $model->search(),
        'filter' => $model,
        'columns' => array(
            'id',
            'user_id',
            'name',
            'adress',
            'phone',
            'city',
            /*
              'state',
              'zip',
              'contacts',
             */
            array(
                'class' => 'CButtonColumn',
            ),
        ),
    ));
}
?>
