<?php

/**
 * This is the model class for table "owner".
 *
 * The followings are the available columns in table 'owner':
 * @property integer $id
 * @property integer $company_id
 * @property string $firstname
 * @property string $lastname
 * @property string $dob
 * @property string $position
 * @property string $phone
 * @property string $notes
 *
 * The followings are the available model relations:
 * @property Company $company
 */
class Owner2 extends CActiveRecord {

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return Owner the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'owner';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
//            array('firstname,lastname,dob, phone, email', 'required'),
//            array('email', 'email','message'=>'The email isn´t correct'),
//            array('company_id', 'numerical', 'integerOnly' => true),
//            array('firstname, lastname', 'length', 'max' => 100),
//            array('phone', 'numerical', 'integerOnly' => true),
//            array('phone', 'length', 'min' => 10, 'max' => 10),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, email, company_id, firstname, lastname, dob, position, phone, notes', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'company' => array(self::BELONGS_TO, 'Company', 'company_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'company_id' => 'Company',
            'firstname' => 'First Name',
            'lastname' => 'Last Name',
            'dob' => 'Dob',
            'position' => 'Position',
            'phone' => 'Phone',
            'notes' => 'Notes',
             'email' => 'E-Mail',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('company_id', $this->company_id);
        $criteria->compare('firstname', $this->firstname, true);
        $criteria->compare('lastname', $this->lastname, true);
        $criteria->compare('dob', $this->dob, true);
        $criteria->compare('position', $this->position, true);
        $criteria->compare('phone', $this->phone, true);
        $criteria->compare('email', $this->email, true);
        $criteria->compare('notes', $this->notes, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

}
