<?php

/**
 * UserIdentity represents the data needed to identity a user.
 * It contains the authentication method that checks if the provided
 * data can identity the user.
 */
class UserIdentity extends CUserIdentity {

    private $_id;

    /**
     * Authenticates a user.
     * The example implementation makes sure if the username and password
     * are both 'demo'.
     * In practical applications, this should be changed to authenticate
     * against some persistent user identity storage (e.g. database).
     * @return boolean whether authentication succeeds.
     */
    public function authenticate() {
//        $user = User::model()->findByAttributes(array("username" => $this->username, "password" => trim(md5($this->password))));
        $user = User::model()->findByAttributes(array("username" => $this->username, "password" => trim(($this->password))));

        if ($user) {
            $this->_id = $user->id;

            $this->setState('__name', $user->username);

            if ($user->superuser == 1) {
                $this->setState('__statusAdmin', 'Admin');
            } else {
                 $this->setState('__statusAdmin', 'UserHere');
            }

            //$this->setState('__statusAdmin', $user->superuser);

            $this->setState('__userid', $user->id);

            $this->errorCode = self::ERROR_NONE;

            $user->lastvisit_at = date("Y-m-d H:i:s");

            $user->save();
        } else
            $this->errorCode = self::ERROR_USERNAME_INVALID;

        return !$this->errorCode;
    }

    public function getId() {
        return $this->_id;
    }

}
