<?php
/* @var $this CompanyController */
/* @var $model Company */
/* @var $form CActiveForm */
?>

<div class="form">
    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'company-form',
        // Please note: When you enable ajax validation, make sure the corresponding
        // controller action is handling ajax validation correctly.
        // There is a call to performAjaxValidation() commented in generated controller code.
        // See class documentation of CActiveForm for details on this.
        'enableAjaxValidation' => false,
    ));
    ?>
    <div class="row">
        <?php echo $form->hiddenField($model, 'user_id', array('type' => 'hidden', 'value' => Yii::app()->user->id)); ?> 
    </div>
    <p class="note">Fields with <span class="required">*</span> are required.</p>

    <?php echo $form->errorSummary($model); ?>
    <?php echo '<br>'; ?>
    <?php echo $form->errorSummary($model->owner); ?>

    <div class="row">
        <?php
        $userStatus = Yii::app()->user->getState('__statusAdmin');
        if ($userStatus == 'Admin') {

            echo $form->dropDownList(
                    $model, 'user_id', CHtml::listData(User::model()->findAll(), 'id', 'username'), array(
                'class' => 'span4 chosen',
                'maxlength' => 20,
                'options' => array('AT' => array('selected' => true)),
                    )
            );
        }
        ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'name'); ?>
        <?php echo $form->textField($model, 'name', array('size' => 60, 'maxlength' => 100)); ?>
        <?php echo $form->error($model, 'name'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'adress'); ?>
        <?php echo $form->textArea($model, 'adress', array('rows' => 4, 'cols' => 50)); ?>
        <?php echo $form->error($model, 'adress'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'phone'); ?>
        <?php echo $form->textField($model, 'phone'); ?>
        <?php echo $form->error($model, 'phone'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'city'); ?>
        <?php echo $form->textField($model, 'city', array('size' => 60, 'maxlength' => 100)); ?>
        <?php echo $form->error($model, 'city'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'state'); ?>
        <?php echo $form->textField($model, 'state', array('size' => 60, 'maxlength' => 100)); ?>
        <?php echo $form->error($model, 'state'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'zip'); ?>
        <?php echo $form->textField($model, 'zip'); ?>
        <?php echo $form->error($model, 'zip'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'notes'); ?>
        <?php echo $form->textArea($model, 'notes', array('rows' => 4, 'cols' => 25)); ?>
        <?php echo $form->error($model, 'notes'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'contacts'); ?>
        <?php echo $form->textArea($model, 'contacts', array('rows' => 4, 'cols' => 25)); ?>
        <?php echo $form->error($model, 'contacts'); ?>
    </div>


    <h3>Owner Information</h3>

    <div class="row">
        <?php echo $form->labelEx($model->owner, 'firstname'); ?>
        <?php echo $form->textField($model->owner, 'firstname'); ?>
        <?php echo $form->error($model->owner, 'firstname'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model->owner, 'lastname'); ?>
        <?php echo $form->textField($model->owner, 'lastname'); ?>
        <?php echo $form->error($model->owner, 'lastname'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model->owner, 'dob'); ?>
        <?php
        $this->widget('zii.widgets.jui.CJuiDatePicker', array(
            'model' => $model->owner,
            //==options==
            'options' => array(
                'dateFormat' => 'yy-mm-dd', // save to db format
                'altField' => 'dob',
                'altFormat' => 'yy-mm-dd', // show to user format
            ),
            //==========
            'attribute' => 'dob',
            'htmlOptions' => array(
                'size' => '10', // textField size
                'maxlength' => '10', // textField maxlength
            ),
        ));
        ?>
        <?php echo $form->error($model->owner, 'dob'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model->owner, 'position'); ?>
        <?php echo $form->textField($model->owner, 'position'); ?>
        <?php echo $form->error($model->owner, 'position'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model->owner, 'phone'); ?>
        <?php echo $form->textField($model->owner, 'phone', array('size' => 10, 'maxlength' => 10, 'minlength' => 10)); ?>
        <?php echo $form->error($model->owner, 'phone'); ?>
    </div>
    <div class="row">
        <?php echo $form->labelEx($model->owner, 'notes'); ?>
        <?php echo $form->textArea($model->owner, 'notes', array('rows' => 4, 'cols' => 25)); ?>
        <?php echo $form->error($model->owner, 'notes'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model->owner, 'email'); ?>
        <?php echo $form->textField($model->owner, 'email'); ?>
        <?php echo $form->error($model->owner, 'email'); ?>
    </div>

    <div class="row buttons">
        <?php //echo CHtml::submitButton($model->isNewRecord ? 'Create' : 'Save');      ?>
        <?php echo CHtml::submitButton($model->isNewRecord ? 'Create' : 'Save', array('class' => 'btn btn-secondary')); ?>
        <?php
        $userStatus = Yii::app()->user->getState('__statusAdmin');
        if ($userStatus == 'Admin') {
            echo CHtml::submitButton('Cancel', array('submit' => array('/company/admin/'), 'class' => 'btn btn-secondary'));
        }
        ?>
    </div>


    <?php $this->endWidget(); ?>

</div><!-- form -->
<style>
    textArea {
        width: 360px;
    }
</style>