<?php

/**
 * This is the model class for table "company".
 *
 * The followings are the available columns in table 'company':
 * @property integer $id
 * @property integer $user_id
 * @property string $name
 * @property string $adress
 * @property string $phone
 * @property string $city
 * @property string $state
 * @property string $zip
 * @property string $contacts
 * @property string $notes
 *
 * The followings are the available model relations:
 * @property Users $user
 * @property Owner[] $owner
 */
class Company extends CActiveRecord {

    private $idCache;

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return Company the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'company';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('user_id, name, adress, phone, city, state, zip, notes', 'required'),
            array('user_id', 'numerical', 'integerOnly' => true),
            array('name, city, state', 'length', 'max' => 100),
            array('phone', 'numerical', 'integerOnly' => true),
            array('zip', 'numerical', 'integerOnly' => true),
            array('phone', 'length', 'min' => 10, 'max' => 11),
            array('zip', 'length', 'min' => 5, 'max' => 5),
            //array('phone, zip', 'length', 'max' => 20),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, user_id, name, adress, phone, city, state, zip, contacts, notes', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            //'user' => array(self::BELONGS_TO, 'Users', 'user_id'),
            'user' => array(self::BELONGS_TO, 'User', 'user_id'),
            'owner' => array(self::HAS_ONE, 'Owner', 'id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'user_id' => 'User',
            'name' => 'Name',
            'adress' => 'Address',
            'phone' => 'Phone',
            'city' => 'City',
            'state' => 'State',
            'zip' => 'Zip',
            'contacts' => 'Contacts',
            'notes' => 'Notes',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
         $userStatus = Yii::app()->user->getState('__statusAdmin');
        // $criteria->compare('id', $this->id);
        $criteria->compare('id', $this->id);
        if ($userStatus == 'Admin') {
            $criteria->compare('user_id', $this->user_id);
        } else {
            $newuserid = Yii::app()->user->getState('__userid');
            $criteria->compare('user_id', $newuserid);
        }
        $criteria->compare('user_id', $this->user_id);
        $criteria->compare('name', $this->name, true);
        $criteria->compare('adress', $this->adress, true);
        $criteria->compare('phone', $this->phone, true);
        $criteria->compare('city', $this->city, true);
        $criteria->compare('state', $this->state, true);
        $criteria->compare('zip', $this->zip, true);
        $criteria->compare('contacts', $this->contacts, true);
        $criteria->compare('notes', $this->notes, true);


        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

   
}
