<?php /* @var $this Controller */ ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <meta name="language" content="en" />

        <!-- blueprint CSS framework -->
        <link rel="stylesheet" type="text/css" href="<?php echo Yii::app()->request->baseUrl; ?>/css/screen.css" media="screen, projection" />
        <link rel="stylesheet" type="text/css" href="<?php echo Yii::app()->request->baseUrl; ?>/css/print.css" media="print" />
        <!--[if lt IE 8]>
        <link rel="stylesheet" type="text/css" href="<?php echo Yii::app()->request->baseUrl; ?>/css/ie.css" media="screen, projection" />
        <![endif]-->

        <link rel="stylesheet" type="text/css" href="<?php echo Yii::app()->request->baseUrl; ?>/css/main.css" />
        <link rel="stylesheet" type="text/css" href="<?php echo Yii::app()->request->baseUrl; ?>/css/form.css" />

        <?php echo Yii::app()->bootstrap->init(); ?>

        <title><?php echo CHtml::encode($this->pageTitle); ?></title>

    </head>

    <body>

        <div class="container" id="page">

            <div id="header">
                <div class="form">
                    <?php
                    $model = new User();
                    $form = $this->beginWidget('CActiveForm', array(
                        'id' => 'my-search-form',
                        'action' => array('user/indexsearch'),
                        'enableClientValidation' => true,
                        'clientOptions' => array(
                            'validateOnSubmit' => true,
                        ),
                    ));
                    ?>

                    <div class="row-fluid">
                        <div class="span6"></div>
                        
                        <div class="span6">
                            <div class="row-fluid">
                                <div class="header-search-btn">
                                    <?php
                                    $this->widget(
                                            'bootstrap.widgets.TbButton', array(
                                        'label' => 'Search',
                                        'type' => 'primary',
                                        'buttonType' => 'submit',
                                            )
                                    );
//echo CHtml::submitButton('Search'); 
                                    ?>
                                </div>
                                <div class="header-search">
                                    <?php //echo $form->labelEx($model, 'phone'); ?>
                                    <?php echo $form->textField($model, 'phone'); ?>
                                    <?php echo $form->error($model, 'phone'); ?>
                                </div>
                                
                                <div style="float:right;"><label style="font-size: 18px; font-weight: normal; margin-top: 8px;">Enter Phone Number:</label></div>

                            </div>
                        </div>

                    </div>

                    <?php $this->endWidget(); ?>
                </div>



            </div><!-- header -->

            <div class="container-radius">
            <div id="mainmenu">
                <?php
                $this->widget('bootstrap.widgets.TbMenu', array(
                    'type' => 'tabs', // '', 'tabs', 'pills' (or 'list')
                    'stacked' => false, // whether this is a stacked menu
                    'items' => array(
                        //array('label' => 'Home', 'url' => array('/site/index/'), 'active' => true),
                        //array('label' => 'Search', 'url' => array('/user/indexsearch/')),
                        array('label' => 'DashBoard', 'url' => array('/user/' . Yii::app()->user->getState('__userid')), 'visible' => Yii::app()->user->getState('__statusAdmin') == 'UserHere'),
                       // array('label' => 'Edit Profile', 'url' => array('/user/update/' . Yii::app()->user->getState('__userid')), 'visible' => Yii::app()->user->getState('__statusAdmin') == 'UserHere'),
                        array('label' => 'Manage Companies', 'url' => array('/company/useradmin/' . Yii::app()->user->getState('__userid')), 'visible' => Yii::app()->user->getState('__statusAdmin') == 'UserHere'),

                        array('label' => 'Manage User', 'url' => array('/user/admin/'), 'visible' => Yii::app()->user->getState('__statusAdmin') == 'Admin'),
                        array('label' => 'Manage Companies', 'url' => array('/company/admin/'), 'visible' => Yii::app()->user->getState('__statusAdmin') == 'Admin'),
                        array('label' => 'Login', 'url' => array('/site/login'), 'visible' => Yii::app()->user->isGuest, 'active' => true),
                        array('label' => 'Logout (' . Yii::app()->user->name . ')', 'url' => array('/site/logout'), 'visible' => !Yii::app()->user->isGuest)
                    ),
                ));
                ?>
            </div><!-- mainmenu -->
            <?php if (isset($this->breadcrumbs)): ?>
                <?php
                $this->widget('zii.widgets.CBreadcrumbs', array(
                    'links' => $this->breadcrumbs,
                ));
                ?><!-- breadcrumbs -->
            <?php endif ?>

            <?php echo $content; ?>

            <div class="clear"></div>

<!--            <div id="footer">
                <label style="font-size: 16px;"> Copyright <?php // echo date('Y');        ?> Â©<br/></label>
                Copyright &copy; <?php // echo date('Y');        ?> Â©<br/>
                                //All Rights Reserved.<br/>
                <?php //echo Yii::powered(); ?>
            </div> footer -->
            
            </div>

        </div><!-- page -->

    </body>
</html>
