<?php
/* @var $this CompanyController */
/* @var $model Company */
/* @var $form CActiveForm */
?>

<div class="form">

    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'company-form',
        // Please note: When you enable ajax validation, make sure the corresponding
        // controller action is handling ajax validation correctly.
        // There is a call to performAjaxValidation() commented in generated controller code.
        // See class documentation of CActiveForm for details on this.
        'enableAjaxValidation' => false,
    ));
    ?>

    <p class="note">Fields with <span class="required">*</span> are required.</p>

    <?php echo $form->errorSummary($model); ?>
     <?php echo $form->errorSummary($modelowner); ?>

    <div class="row">
        <?php echo $form->hiddenField($model, 'user_id', array('type' => 'hidden', 'value' => $user_id)); ?> 
        <?php // echo $form->labelEx($model,'user_id'); ?>
        <?php // echo $form->textField($model,'user_id');  ?>
        <?php // echo $form->error($model,'user_id');  ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'name'); ?>
        <?php echo $form->textField($model, 'name', array('size' => 60, 'maxlength' => 100)); ?>
        <?php echo $form->error($model, 'name'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'adress'); ?>
        <?php echo $form->textArea($model, 'adress', array('rows' => 4, 'cols' => 50)); ?>
        <?php echo $form->error($model, 'adress'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'phone'); ?>
        <?php echo $form->textField($model, 'phone', array('integer' => 'true')); ?>
        <?php echo $form->error($model, 'phone'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'city'); ?>
        <?php echo $form->textField($model, 'city', array('size' => 60, 'maxlength' => 100)); ?>
        <?php echo $form->error($model, 'city'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'state'); ?>
        <?php echo $form->textField($model, 'state', array('integer' => 'true')); ?>
        <?php echo $form->error($model, 'state'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'zip'); ?>
        <?php echo $form->textField($model, 'zip', array('size' => 60, 'maxlength' => 100)); ?>
        <?php echo $form->error($model, 'zip'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($model, 'contacts'); ?>
        <?php echo $form->textArea($model, 'contacts', array('rows' => 4, 'cols' => 50)); ?>
        <?php echo $form->error($model, 'contacts'); ?>
    </div>
    <div class="row">
        <?php echo $form->labelEx($model, 'notes'); ?>
        <?php echo $form->textArea($model, 'notes', array('rows' => 4, 'cols' => 50)); ?>
        <?php echo $form->error($model, 'notes'); ?>
    </div>
    <h3>Owner Information</h3>

    <div class="row">
        <?php echo $form->labelEx($modelowner, 'firstname'); ?>
        <?php echo $form->textField($modelowner, 'firstname'); ?>
        <?php echo $form->error($modelowner, 'firstname'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($modelowner, 'lastname'); ?>
        <?php echo $form->textField($modelowner, 'lastname'); ?>
        <?php echo $form->error($modelowner, 'lastname'); ?>
    </div>
    
    <div class="row">
        <?php echo $form->labelEx($modelowner, 'position'); ?>
        <?php echo $form->textField($modelowner, 'position'); ?>
        <?php echo $form->error($modelowner, 'position'); ?>
    </div>

    <div class="row">
         <?php echo $form->labelEx($modelowner, 'dob'); ?>
         <?php
        $this->widget('zii.widgets.jui.CJuiDatePicker', array(
            'model' => $modelowner,
            //==options==
            'options' => array(
                'dateFormat' => 'yy-mm-dd', // save to db format
                'altField' => 'dob',
                'altFormat' => 'yy-mm-dd', // show to user format
            ),
            //==========
            'attribute' => 'dob',
            'htmlOptions' => array(
                'size' => '10', // textField size
                'maxlength' => '10', // textField maxlength
            ),
        ));
        ?>
        <?php echo $form->error($modelowner, 'dob'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($modelowner, 'phone'); ?>
        <?php echo $form->textField($modelowner, 'phone'); ?>
        <?php echo $form->error($modelowner, 'phone'); ?>
    </div>
    <div class="row">
        <?php echo $form->labelEx($modelowner, 'notes'); ?>
        <?php echo $form->textArea($modelowner, 'notes', array('rows' => 4, 'cols' => 25)); ?>
        <?php echo $form->error($modelowner, 'notes'); ?>
    </div>
    
 
     <div class="row">
        <?php echo $form->labelEx($modelowner, 'email'); ?>
        <?php echo $form->textField($modelowner, 'email'); ?>
        <?php echo $form->error($modelowner, 'email'); ?>
    </div>
    
    




    <div class="row buttons">
        <?php echo CHtml::submitButton($model->isNewRecord ? 'Create' : 'Save', array('class' => 'btn btn-secondary')); ?>
        <?php echo CHtml::submitButton('Cancel', array('submit' => array('/company/useradmin/' . Yii::app()->user->getState('__userid')), 'class' => 'btn btn-secondary')); ?>

    </div>

    <?php $this->endWidget(); ?>

</div><!-- form -->
<style>
    textArea {
        width: 360px;
    }
</style>