<?php

/**
 * This is the model class for table "users".
 *
 * The followings are the available columns in table 'users':
 * @property integer $id
 * @property string $username
 * @property string $password
 * @property string $email
 * @property string $created_at
 * @property string $lastvisit_at
 * @property integer $superuser
 * @property integer $status
 * @property integer $phone
 *
 * The followings are the available model relations:
 * @property Company[] $companies
 */
class User extends CActiveRecord {

    private $idCache;

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'users';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('username, password, email, phone', 'required'),
            array('username', 'unique', 'message'=>'This UserName is already in use'),   
            array('superuser, status, phone', 'numerical', 'integerOnly' => true),
            array('phone', 'unique', 'message'=>'This Phone is already in use'),  
             array('email', 'email','message'=>'The email isn´t correct'),
            array('email', 'unique', 'message'=>'This Email is already in use'),   
            array('username', 'length', 'max' => 20),
            array('phone', 'length', 'min'=>10, 'max'=>11),
            array('password, email', 'length', 'max' => 128),
            //array('created_at', 'date'),
            array('lastvisit_at', 'safe'),
            array('email', 'unique', 'message' => 'Email is not valid'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, username, password, email, created_at, lastvisit_at, superuser, status, phone', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'companies' => array(self::HAS_MANY, 'Company', 'user_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'username' => 'Username',
            'password' => 'Password',
            'email' => 'Email',
            'created_at' => 'Created At',
            'lastvisit_at' => 'Lastvisit At',
            'superuser' => 'Superuser',
            'status' => 'Status',
            'phone' => 'Phone',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('username', $this->username, true);
        $criteria->compare('password', $this->password, true);
        $criteria->compare('email', $this->email, true);
        $criteria->compare('created_at', $this->created_at, true);
        $criteria->compare('lastvisit_at', $this->lastvisit_at, true);
        $criteria->compare('superuser', $this->superuser);
        $criteria->compare('status', $this->status);
        $criteria->compare('phone', $this->phone);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return User the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function beforeSave() {
        if ($this->isNewRecord) {
            $this->created_at = date("Y-m-d H:i:s");
            $this->lastvisit_at = date("Y-m-d H:i:s");
        } else {
            $this->lastvisit_at = date("Y-m-d H:i:s");
            //$this->created_at = date("Y-m-d H:i:s");
        }


        return parent::beforeSave();
    }

    public static function getUsers() {
        $data = User::model()->findAll();

        $data = CHtml::listData($data, 'id', 'name');
        foreach ($data as $value => $name) {
            echo CHtml::tag('option', array('value' => $value), CHtml::encode($name), true);
        }
    }

    public function beforeDelete() {
        $this->idCache = $this->id;
        $criteria = new CDbCriteria(array(
            'condition' => 'user_id=:userID',
            'params' => array(
                ':userID' => $this->idCache),
        ));
        $children = Company::model()->findAll($criteria);

        foreach ($children as $child) {
            $child->delete();
        }


        return parent::beforeDelete();
    }

}
