<?php


/**
 * UserIdentity represents the data needed to identity a user.
 * It contains the authentication method that checks if the provided
 * data can identity the user.
 */
class UserIdentity extends CUserIdentity {

     /**
      * Authenticates a user.
      * The example implementation makes sure if the EMAIL and password
      * are both 'demo'.
      * In practical applications, this should be changed to authenticate
      * against some persistent user identity storage (e.g. database).
      * @return boolean whether authentication succeeds.
      */
     private $_id;
     public $username;

     public function __construct($username, $password) {
          $this->username = $username;
          $this->password = $password;
     }

     /**
      * Authenticates a user.
      * The example implementation makes sure if the EMAIL and password
      * are both 'demo'.
      * In practical applications, this should be changed to authenticate
      * against some persistent user identity storage (e.g. database).
      * @return boolean whether authentication succeeds.
      */
     public function authenticate() {
          $contact = User::model()->findByAttributes(array('username' => $this->username));
          if ($contact === null)
               $this->errorCode = self::ERROR_EMAIL_INVALID;
          else if ($contact->password !== $contact->encrypt($this->password))
               $this->errorCode = self::ERROR_PASSWORD_INVALID;
          else {
               $this->_id = $contact->id;
               $this->errorCode = self::ERROR_NONE;
          }
          return $this->errorCode == self::ERROR_NONE;
     }

          public function getId() {
          return $this->_id;
     }

}
//class UserIdentity extends CUserIdentity
//{
//    private $_id;
// 
//    public function authenticate()
//    {
//        $username=strtolower($this->username);
//        $user=User::model()->find('LOWER(username)=?',array($username));
//        if($user===null)
//            $this->errorCode=self::ERROR_USERNAME_INVALID;
//        else if(!$user->validatePassword($this->password))
//            $this->errorCode=self::ERROR_PASSWORD_INVALID;
//        else
//        {
//            $this->_id=$user->id;
//            $this->username=$user->username;
//            $this->errorCode=self::ERROR_NONE;
//        }
//        return $this->errorCode==self::ERROR_NONE;
//    }
// 
//    public function getId()
//    {
//        return $this->_id;
//    }
//}
/**
 * UserIdentity represents the data needed to identity a user.
 * It contains the authentication method that checks if the provided
 * data can identity the user.
 */
//class UserIdentity extends CUserIdentity {
//
//    private $_id;
//    public $username;
//
//    public function __construct($username, $password) {
//        $this->username = $username;
//        $this->password = $password;
//    }
//
//    /**
//     * Authenticates a user.
//     * The example implementation makes sure if the username and password
//     * are both 'demo'.
//     * In practical applications, this should be changed to authenticate
//     * against some persistent user identity storage (e.g. database).
//     * @return boolean whether authentication succeeds.
//     */
//    public function authenticate() {
//        $users = User::model()->findByAttributes(array('username' => $this->username));
//        print_r($users);exit;
//        if (!isset($users[$this->username]))
//            $this->errorCode = self::ERROR_USERNAME_INVALID;
//        elseif ($users[$this->username] !== $this->password)
//            $this->errorCode = self::ERROR_PASSWORD_INVALID;
//        else
//            $this->errorCode = self::ERROR_NONE;
//        return !$this->errorCode;
//    }
//
//    public function getId() {
//        return $this->_id;
//    }
//
//}
